; Projection of the posterior in the om_oL and om-w planes.
; Isocontours represent the 68.3, 95 and 99% c.l. 

pro plik

    restore,  'plik_omol.sav'
    restore,  'plik_omw.sav'

    sl1=2.3 
    sl2=6.17
    sl3=11.8 

    levels_omol=[min(plik_omol), min(plik_omol)+sl1, min(plik_omol)+sl2, min(plik_omol)+sl3]
    levels_omw=[min(plik_omw), min(plik_omw)+sl1, min(plik_omw)+sl2, min(plik_omw)+sl3]    
    

    set_Plot, 'PS' 
    device, filename='post_lik.ps',xsize=6.5,ysize=6.5,xoff=1, yoff=2.25, /inch, /color 
      
    tek_color
    
    contour, plik_omol, om,ol, levels=levels_omol, xtitle='!7X!I!3m!N',  ytitle='!7X!I!7K!X!N', c_thick=[6,6,6],charsize=2,title=title,xthick=6,ythick=6,charthick=6,xstyle=1, ystyle=1, /fill, c_colors=[9,7,2,15]


    contour, plik_omw, om,w, levels=levels_omw, xtitle='!7X!I!3m!N',  ytitle='w!I0!N', c_thick=[6,6,6],charsize=2,title=title,xthick=6,ythick=6,charthick=6,xstyle=1, ystyle=1, /fill, c_colors=[9,7,2,15]

      
    device, /close
    set_PLot, 'X'
    spawn, 'gv post_lik.ps &' 

end

